package net.ekiii.dexev2;

import java.util.ArrayList;
import java.util.HashMap;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.PixelFormat;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnTouchListener;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.FrameLayout.LayoutParams;
import android.widget.ImageView.ScaleType;


public class Game extends Activity implements OnClickListener,DialogInterface.OnClickListener {

	int bWidth=32;
	private int ScreenHeight;
	private int ScreenWidth;
	
	public static final int SOUND_EXPLOSION = 1;
    public static final int SOUND_YOU_WIN = 2;
    public static final int SOUND_YOU_LOSE = 3;
    public static final int SOUND_SLING = 4;
    public static final int SOUND_SLING2 = 5;
    public static final int SOUND_UNDO = 6;

   private SoundPool soundPool;
    private HashMap<Integer, Integer> soundPoolMap;
    
    private void initSounds() {
         soundPool = new SoundPool(4, AudioManager.STREAM_MUSIC, 100);
         soundPoolMap = new HashMap<Integer, Integer>();
         soundPoolMap.put(SOUND_EXPLOSION, soundPool.load(this, R.raw.explode2, 1));
         soundPoolMap.put(SOUND_YOU_WIN, soundPool.load(this, R.raw.gold, 1));
         soundPoolMap.put(SOUND_SLING, soundPool.load(this, R.raw.sling, 1));
         soundPoolMap.put(SOUND_SLING2, soundPool.load(this, R.raw.sling2, 1));
         soundPoolMap.put(SOUND_UNDO, soundPool.load(this, R.raw.undo, 1));
    }
    
    public void playSound(int sound) {
         AudioManager mgr = (AudioManager) this.getSystemService(Context.AUDIO_SERVICE);
         int streamVolume = mgr.getStreamVolume(AudioManager.STREAM_MUSIC);
         soundPool.play(soundPoolMap.get(sound), streamVolume, streamVolume, 1, 0, 1f);
    }

    public void explode() {
    	if (sound)
    	playSound(SOUND_EXPLOSION);
    } 
    public void win() {
    	if (sound)
    	playSound(SOUND_YOU_WIN);
    } 
    public void sling() {
    	if (sound)
    		playSound(SOUND_SLING);
    } 
    public void sling2() {
    	if (sound)
    		playSound(SOUND_SLING2);
    }
  	public void undo() {
    		if (sound)
    			playSound(SOUND_UNDO);
    } 
	
	private class BlueDrawable extends Drawable {
		protected final GameAdapter m;
		private BlueDrawable(GameAdapter ga) {
			this.m = ga;
		}

		@Override
		public void draw(Canvas canvas) {
			ScreenHeight = canvas.getClipBounds().bottom-canvas.getClipBounds().top;
			ScreenWidth = canvas.getWidth();
			int dy=(ScreenHeight-8*bWidth)/2;
			int dx=(ScreenWidth-10*bWidth)/2;
			
			StringBuffer[] board = m.board;
			int i=0;
			canvas.save();
			canvas.clipRect(dx, dy, dx+10*bWidth, dy+8*bWidth);
			canvas.drawARGB(128, 0, 0, 0);
			canvas.restore();


			for (StringBuffer sb:board)
			{
				i++;
				for (int j=0;j<10;j++)
				{
					//					if ((c!='0') && (c!='9')) {
					//				          tot++;
					//				          this.jewels[Character.getNumericValue(c)]++;
					//				        }
					Matrix m= new Matrix();
					int tx=dx+bWidth*j;
					int ty=dy+bWidth*(i-1);
					m.setTranslate(tx, ty);
					m.preScale(bscale, bscale);
//					Log.i("Dessine", "("+j+", "+i+") scale["+bscale+"]   { "+tx+", "+ty+"}");
					char char$ = sb.charAt(j);
					Bitmap bitmap = getBitmap(char$);
					if (bitmap!=null)
						canvas.drawBitmap(bitmap, m, null);
				}

			}// Fin boucle
			//			if (m.XY!=null)
			{
				int px = curseurX;
				int py = curseurY;
				Matrix m= new Matrix();
				m.setTranslate(dx+bWidth*px, dy+bWidth*(py));
				m.preScale(bscale, bscale);
				canvas.drawBitmap(select.getBitmap(), m, null);
			}
			if (m.XY!=null)
			{
				int px = m.XY[0];
				int py = m.XY[1];
				Matrix m= new Matrix();
				m.setTranslate(dx+bWidth*px, dy+bWidth*(py));
				m.preScale(bscale, bscale);
				canvas.drawBitmap(select2.getBitmap(), m, null);
			}

		}

		@Override
		public int getOpacity() {
			return PixelFormat.TRANSLUCENT;
		}

		@Override
		public void setAlpha(int alpha) {

		}

		@Override
		public void setColorFilter(ColorFilter cf) {

		}
	}

	String[] skinnames = {"Jewels","Blocks"};
	AlertDialog qd=null;
	AlertDialog sd=null;
	GameAdapter ga;
	BitmapDrawable b;
	BitmapDrawable b0;
	BitmapDrawable b1;
	BitmapDrawable b2;
	BitmapDrawable b3;
	BitmapDrawable b4;
	BitmapDrawable b5;
	BitmapDrawable b6;
	BitmapDrawable b7;
	BitmapDrawable b8;
	float bscale;
	BitmapDrawable select;
	BitmapDrawable select2;
	Handler h;
	private boolean animation;
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		h = new Handler();
		SharedPreferences preferences = getSharedPreferences(Main.PREFS_NAME, 0);
		sound = preferences.getBoolean(Main.SOUND, true);
		animation = preferences.getBoolean(Main.ANIMATION, true);
		initSounds();
		b = new BitmapDrawable(getResources().openRawResource(R.drawable.w));
		b0 = new BitmapDrawable(getResources().openRawResource(R.drawable.w2));
		b1 = new BitmapDrawable(getResources().openRawResource(R.drawable.b1));
		b2 = new BitmapDrawable(getResources().openRawResource(R.drawable.b2));
		b3 = new BitmapDrawable(getResources().openRawResource(R.drawable.b3));
		b4 = new BitmapDrawable(getResources().openRawResource(R.drawable.b4));
		b5 = new BitmapDrawable(getResources().openRawResource(R.drawable.b5));
		b6 = new BitmapDrawable(getResources().openRawResource(R.drawable.b6));
		b7 = new BitmapDrawable(getResources().openRawResource(R.drawable.b7));
		b8 = new BitmapDrawable(getResources().openRawResource(R.drawable.b8));
		select = new BitmapDrawable(getResources().openRawResource(R.drawable.select));
		select2 = new BitmapDrawable(getResources().openRawResource(R.drawable.select2));
		Intent i=getIntent();
		currentLevel = new Level(i.getExtras().getString("net.ekiii.dexev.Title"),
				i.getExtras().getString("net.ekiii.dexev.Board"),
				i.getExtras().getString("net.ekiii.dexev.Solution"));

		int screenHeight = getWindowManager().getDefaultDisplay().getHeight();
		int screenWidth = getWindowManager().getDefaultDisplay().getWidth();
		bWidth=(int) Math.floor(Math.min((screenHeight-54)/8,screenWidth/10));
		bscale = ((float)bWidth)/b.getBitmap().getWidth();
		Log.i("SETUP", "Block size:"+bWidth+" (scale="+bscale+")");
		
		this.ga = new GameAdapter(this,currentLevel);
		imageView = new ImageView(this);
		imageView.setImageDrawable(new BlueDrawable(ga));
		frameLayout = new FrameLayout(this);
		ImageView fondView = new ImageView(this);
		fondView.setScaleType(ScaleType.CENTER_CROP);
		fondView.setImageDrawable(getResources().getDrawable(R.drawable.fond));

		frameLayout.addView(fondView);
		frameLayout.addView(imageView);
		setContentView(frameLayout);
		
		setTitle(currentLevel.title+" "+"0/"+Integer.toString((currentLevel.solution.length()/2)));

		//this.ga.notifyDataSetsChanged();

		imageView.setOnKeyListener(ga);
		fondView.setOnKeyListener(ga);



	}

	public void onClick(View v) {
		if (v.getId()==R.id.quitbutton) {
			qd=new AlertDialog.Builder(this)
			.setTitle("Quit?")
			.setMessage("Are you sure you want to abandon this level?")
			.setPositiveButton("Quit", (DialogInterface.OnClickListener) this)
			.setNegativeButton("Continue", (DialogInterface.OnClickListener) this)
			.create();
			qd.show();
		} else if (v.getId()==R.id.undobutton) {
			this.ga.undo();
		}

	}



	@Override
	public boolean onTouchEvent(MotionEvent event) {
		float x = event.getX();
		float y = event.getY();
		Log.i("clic", "------------------------( "+x+", "+y+")");

		int width=ScreenWidth;
		int height=ScreenHeight;
//		int width=getWindowManager().getDefaultDisplay().getWidth();
//		int height=getWindowManager().getDefaultDisplay().getHeight();

		int dy=(height-8*bWidth)/2;
		int dx=(width-10*bWidth)/2;

		int px=(int) (x-dx);
		int py=(int) (y-dy)-16;

		int ix=px/bWidth;
		int iy=py/bWidth-1;

		curseurX=ix;
		curseurY=iy;

		Log.i("CURSEUR", "x="+curseurX+"    y="+curseurY);

		if (event.getAction()==MotionEvent.ACTION_DOWN) {
			ga.XY=new int[]{curseurX,curseurY};
			imageView.postInvalidate();
			return true;
		} else if (event.getAction()==MotionEvent.ACTION_UP) {
			int[] newXY=new int[]{curseurX,curseurY};
			boolean didmove=ga.moveFromTo(ga.XY,newXY);
			ga.XY=null;
			imageView.postInvalidate();
			return didmove;

		}

		imageView.postInvalidate();
		return true;

	}



	int curseurX=0;
	int curseurY=0;
	private ImageView imageView;
	private FrameLayout frameLayout;
	private Level currentLevel;
	private boolean sound;

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		Log.i("KEYDOWN", "------------------------("+keyCode+")");
		if (ga.onKey(null, keyCode, event))
		{
			imageView.postInvalidate();
			Log.i("GameAdapter", "Catch event ("+keyCode+")");
			return true;
		}
		if (keyCode!=4&&keyCode!=19&&keyCode!=20&&keyCode!=21&&keyCode!=22&&keyCode!=23)
			return false;

		if (keyCode==23)
		{
			if (ga.XY==null)
			{
				ga.XY=new int[]{curseurX,curseurY};
				imageView.postInvalidate();
				return true;
			}
			else {
				int[] newXY=new int[]{curseurX,curseurY};
				@SuppressWarnings("unused")
				boolean didmove=ga.moveFromTo(ga.XY,newXY);
				ga.XY=null;
				imageView.postInvalidate();
				return true;
			}
		}
		if (keyCode==21) 
			curseurX-=1;
		if (keyCode==22) 
			curseurX+=1;
		if (keyCode==19) 
			curseurY-=1;
		if (keyCode==20) 
			curseurY+=1;
		if (keyCode==4) 
			ga.undo();

		Log.i("CURSEUR", "x="+curseurX+"    y="+curseurY);
		imageView.postInvalidate();
		/*
        int[] newXY=new int[2];
        newXY[1]=this.XY[1];
        if (KeyCode==21) {
          newXY[0]=this.XY[0]-1;
        } else {
          newXY[0]=this.XY[0]+1;
        }
        moveFromTo(this.XY,newXY);
        this.XY=null;
        return true;
		 */
		return true; 
	}






	public void onClick(DialogInterface dialog, int which) {
		AlertDialog ad=(AlertDialog) dialog;
		dialog.dismiss();
		if (ad==qd) {
			//if (which==DialogInterface.BUTTON_POSITIVE) {
			if (which==DialogInterface.BUTTON1) {
				this.setResult(RESULT_CANCELED);
				this.finish();
			}
		} else if (ad==sd) {
//			ga.setSkin(which);
		}
	}

	public boolean onCreateOptionsMenu(Menu menu) {
		MenuItem clear=menu.add(0,3,0,"Clear");
		clear.setIcon(android.R.drawable.ic_menu_revert);
		MenuItem help=menu.add(0,1,0,"Help");
		help.setIcon(android.R.drawable.ic_menu_help);
		MenuItem exit = menu.add(0,0,0,"Exit");
		exit.setIcon(android.R.drawable.ic_menu_close_clear_cancel);
//		MenuItem hint=menu.add(0,2,0,"Hint");
//		hint.setIcon(android.R.drawable.ic_menu_search);
		return true;
	}

	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case 0:
//			sd=new AlertDialog.Builder(this)
//			.setTitle("Select skin")
//			//.setAdapter(new ArrayAdapter<String>(this,android.R.layout.simple_list_item_1,skinnames),this)
//			.setSingleChoiceItems(skinnames, ga.getSkin(), this)
//			.create();
//			sd.show();
			Intent i=new Intent();
			//i.putExtra("net.ekiii.dexev.Score",ga.moves);
			((Activity) this).setResult(0,i);
			((Activity) this).finish();
			return true;
		case 1:
			new AlertDialog.Builder(this)
			.setTitle("Help")
			.setMessage(this.getResources().getText(R.string.help))
			.show();
			break;
		case 2:
			
			new AlertDialog.Builder(this)
			.setTitle("Hint")
			.setMessage(this.getResources().getText(R.string.help))
			.show();
			break;
		case 3:
			while (ga.undolist.size()>0)
				ga.undo();
			frameLayout.postInvalidate();
			break;
		}
		return false;
	}
	private Bitmap getBitmap(char char$) {
		Bitmap bitmap = null;
		switch (char$) {
		case '0': //Wall
			bitmap = b0.getBitmap();
			break;
		case '1': 
			bitmap = b1.getBitmap();
			break;
		case '2': 
			bitmap = b2.getBitmap();
			break;
		case '3': 
			bitmap = b3.getBitmap();
			break;
		case '4': 
			bitmap = b4.getBitmap();
			break;
		case '5': 
			bitmap = b5.getBitmap();
			break;
		case '6': 
			bitmap = b6.getBitmap();
			break;
		case '7': 
			bitmap = b7.getBitmap();
			break;
		case '8': 
			bitmap = b8.getBitmap();
			break;
		case 'B': 
			bitmap = b.getBitmap();
			break;

		default:
			break;
		}
		return bitmap;
	}
	public class GameAdapter implements OnTouchListener,DialogInterface.OnClickListener,AdapterView.OnItemClickListener,View.OnKeyListener {
		private Context mContext;
		private StringBuffer[] board;
		private ArrayList<StringBuffer[]> undolist=new ArrayList<StringBuffer[]>();
		private int[] jewels;
		private int[] XY;
		private String solution;
		private int moves;
		private ImageView[][] ivs;
		private int skin;


		public GameAdapter(Context c,Level l) {
			mContext = c;

			this.jewels=new int[] {0,0,0,0,0,0,0,0,0,0};
			this.board=l.board;
			this.setSolution(l.solution);
			this.moves=0;
			this.ivs=new ImageView[8][10];
			SharedPreferences settings=mContext.getSharedPreferences("Annoyed",0);
			skin=settings.getInt("skin",0);

		}

		public void onClick(DialogInterface dialog, int which) {
			dialog.dismiss();
			Intent i=new Intent();
			i.putExtra("net.ekiii.dexev.Score",moves);
			//if (which==DialogInterface.BUTTON_POSITIVE) {
			if (which==DialogInterface.BUTTON1) {
				((Activity) mContext).setResult(1,i);
				//} else if (which==DialogInterface.BUTTON_NEUTRAL) {
			} else if (which==DialogInterface.BUTTON3) {
				((Activity) mContext).setResult(2,i);
				//} else if (which==DialogInterface.BUTTON_NEGATIVE) {
			} else if (which==DialogInterface.BUTTON2) {
				((Activity) mContext).setResult(3,i);
			}
			((Activity) mContext).finish();
		}

		private int jtot() {
			int tot=0;
			this.jewels=new int[] {0,0,0,0,0,0,0,0,0,0};
			for (int i=0;i<board.length;i++) {
				for (int j=0;j<board[i].length();j++) {
					char c=board[i].charAt(j);
					if ((c!='0') && (c!='9')) {
						tot++;
						this.jewels[Character.getNumericValue(c)]++;
					}
				}
			}
			return tot;
		}

		private void countEm() {
			//logBoard(null);
//			notifyDataSetChanged();
			if (jtot()==0) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				win();
//				for (int i=0;i<128;i+=12)
//				{
//					
//					final int alpha=128-i;
//					h.post(new Runnable(){
//						
//						@Override
//						public void run() {
//							imageView.setAlpha(alpha);
//						}});
//					try {
//						Thread.sleep(50);
//					} catch (InterruptedException e) {}
//					imageView.postInvalidate();
//				}
//				h.post(new Runnable(){
//					
//					@Override
//					public void run() {
//						imageView.setAlpha(0);
//						
//					}});
				final android.content.DialogInterface.OnClickListener this$ = (DialogInterface.OnClickListener) this;
				h.post(new Runnable(){

					@Override
					public void run() {
						new AlertDialog.Builder(mContext)
						.setTitle("You won!")
						.setMessage("Would you like to play the next level, try this one again, or go back to the front screen?")
						.setPositiveButton("Next Level", this$ )
						.setNeutralButton("Try Again", this$)
						.setNegativeButton("Go Back", this$)
						.show();
					}});
			}
//			for (int i=1;i<9;i++) {
//				if (this.jewels[i]==1) {
//					Log.i("ann","You've Lost!");
//				}
//			}
		}

		private int[] getXY(MotionEvent event) {
			GridView gv = (GridView) ((Activity) mContext).findViewById(R.id.gridview);
			int top=gv.getTop();
			float fx=event.getX();
			fx-=5;
			fx/=bWidth;
			int x=(int)fx;
			float fy=event.getY();
			fy+=(float) top;
			fy-=5;
			fy/=bWidth;
			int y=(int)fy;
			int[] ret={x,y};
			return ret;
		}

		private boolean moveBlock(final int[] coord, final int dir) {
			final StringBuffer row;
			final char block;
			try {
				row = this.board[coord[1]];
				block = row.charAt(coord[0]);
			} catch (Exception e) {
				return false;
			}
			if ((block=='9') || (block=='0')) {
				;
			} else {
				if (row.charAt(coord[0]+dir)=='9') {
					saveundo();
					sling2();
					new Thread(new Runnable() {
						
						@Override
						public void run() {
							
							if (dir==1) {
								final Bitmap bitmap = getBitmap(row.charAt(coord[0]));
								row.replace(coord[0],coord[0]+2,"99");
								moveAnim(coord, dir, bitmap);
								row.replace(coord[0],coord[0]+2,"9"+block);
							} else {
								final Bitmap bitmap = getBitmap(row.charAt(coord[0]));
								row.replace(coord[0]-1,coord[0]+1,"99");
								moveAnim(coord, dir, bitmap);
								row.replace(coord[0]-1,coord[0]+1,block+"9");
							}
							boolean moved=true;
							boolean explode=false;
							while (moved) {
								while (moved) {
									moved=doGravity();
									if (moved)
										sling();
								}
								moved=doExplosion();
								explode|=moved;
							}
							if (explode)
							{
								Log.i("EXPLODE", "BOOOOOOOOOOOOOOOOOOOM");
								explode();
							}
							
							countEm();
							imageView.postInvalidate();
						}
					}).start();
					//logBoard(null);
					this.board[coord[1]]=row;
					//logBoard(null);
					moves++;
					setTitle(currentLevel.title+" "+Integer.toString(moves)+"/"+Integer.toString((currentLevel.solution.length()/2)));
					return true;
				}
			}
			return false;
		}

		private void moveAnim(final int[] coord, final int dir,final Bitmap bitmap) {
			
			final Matrix m = new Matrix();
			final int dy=(ScreenHeight-8*bWidth)/2;
			final int dx=(ScreenWidth-10*bWidth)/2;
			int tx=dx+bWidth*coord[0];
			int ty=dy+bWidth*(coord[1]);
			m.setTranslate(tx, ty);
			m.preScale(bscale, bscale);
			final ImageView fondView = new ImageView(Game.this);
			fondView.setScaleType(ScaleType.MATRIX);
			fondView.setImageMatrix(m);
			fondView.setImageBitmap(bitmap);
			h.post(new Runnable(){
				
				@Override
				public void run() {
					imageView.invalidate();
					FrameLayout.LayoutParams params=new LayoutParams(LayoutParams.FILL_PARENT,LayoutParams.FILL_PARENT);
					frameLayout.addView(fondView,params);
				}
			}
			);
			for (int i=0;i<15;i++)
			{
				final int index=i;
				try {
					Thread.sleep(20);
					h.post(new Runnable(){

						@Override
						public void run() {
							m.reset();
							int tx=dx+bWidth*coord[0]+dir*(index*bWidth)/16;
							int ty=dy+bWidth*(coord[1])+(dir==0?1:0)*(index*bWidth)/16;;
							m.setTranslate(tx, ty);
							m.preScale(bscale, bscale);
							fondView.setImageMatrix(m);
							fondView.setImageBitmap(bitmap);
							fondView.postInvalidate();
						}
					}
					);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}

			}
			h.post(new Runnable(){
				
				@Override
				public void run() {
					frameLayout.removeView(fondView);
				}
			}
			);
		}

		public boolean doGravity() {
			StringBuffer row;
			StringBuffer rowplus;
			boolean ret=false;
			for (int i=0;i<board.length-1;i++) {
				row=board[i];
				rowplus=board[i+1];
				for (int j=0;j<row.length();j++) {
					char block=row.charAt(j);
					if ((block!='0') && (block!='9')) {
						if (rowplus.charAt(j)=='9') {
							row.replace(j,j+1,"9");
							
							rowplus.replace(j,j+1,Character.toString(block));
							ret=true;
						}
					}
				}
				board[i]=row;
				board[i+1]=rowplus;
			}
			return ret;
		}
		public boolean doExplosion() {
			boolean[][] marks=new boolean[board.length][];
			boolean[] row;
			boolean ret=false;
			for (int i=0 ; i<board.length ; i++) {
				row=new boolean[10];
				for (int j=0 ; j<10 ; j++) {
					if ((board[i].charAt(j)!='0') && (board[i].charAt(j)!='9')) {
						if (j>0) {
							row[j]|=(board[i].charAt(j)==board[i].charAt(j-1));
						}
						if (j<row.length) {
							row[j]|=(board[i].charAt(j)==board[i].charAt(j+1));
						}
						if (i>0) {
							row[j]|=(board[i].charAt(j)==board[i-1].charAt(j));
						}
						if (i<board.length) {
							row[j]|=(board[i].charAt(j)==board[i+1].charAt(j));
						}
					}
				}
				marks[i]=row;
			}
			for (int i=0 ; i<board.length ; i++) {
				for (int j=0 ; j<10 ; j++) {
					if (marks[i][j]) {
						board[i].replace(j,j+1,"9");
						Log.i("DEXEV","Explose ("+i+","+j+")");
						//            iv.startAnimation(animation);
						if (animation)
							new Thread(new Explode(j,i)).start();
						ret=true;
					}
				}
			}
			return ret;

		}

		final BitmapDrawable[] fis = new BitmapDrawable[16];
		{

			for (int i=1;i<16;i++)
			{

				int identifier = getResources().getIdentifier(getPackageName()+":drawable/"+"fi"+i, null, null);
				fis[i-1] = new BitmapDrawable(getResources().openRawResource(identifier));
			}

		}
		int fiheight=fis[0].getBitmap().getHeight();
		int fiwidth=fis[0].getBitmap().getWidth();

		public class Explode implements Runnable {
			
			int x,y;
				
			
			public Explode(int x, int y) {
				super();
				this.x = x;
				this.y = y;
			}


			@Override
			public void run() {
				final Matrix m = new Matrix();
				int dy=(ScreenHeight-8*bWidth)/2;
				int dx=(ScreenWidth-10*bWidth)/2;
				
				m.setTranslate(dx+bWidth*x+bWidth/2-fiwidth/2, dy+bWidth*(y-1)+bWidth-fiheight/2);
				final ImageView fondView = new ImageView(Game.this);
				fondView.setScaleType(ScaleType.MATRIX);
				fondView.setImageDrawable(fis[0]);
				h.post(new Runnable(){
					
					@Override
					public void run() {
						frameLayout.addView(fondView);
						fondView.setImageMatrix(m);
					}
				}
				);
				for (int i=0;i<15;i++)
				{
					final int index=i;
					try {
						Thread.sleep(50);
						h.post(new Runnable(){

							@Override
							public void run() {
								fondView.setImageDrawable(fis[index]);
							}
						}
						);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}

				}
				h.post(new Runnable(){
					
					@Override
					public void run() {
						frameLayout.removeView(fondView);
					}
				}
				);
				frameLayout.postInvalidate();
			}

		}

		public void logBoard(StringBuffer[] b) {
			if (b==null) {
				b=board;
			};
			for (int i=0;i<this.board.length;i++) {
				Log.i("DEXEV","Board "+i+": "+board[i]);
			}
		}

		public void saveundo() {
			StringBuffer[] saved=new StringBuffer[board.length];
			for (int i=0;i<board.length;i++) {
				saved[i]=new StringBuffer(board[i]);
			}
			undolist.add(saved);
		}

		public void undo() {
			Log.i("DEXEV","Undo");
			if (undolist.size()>0) {
				Game.this.undo();
				//Log.i("ann","Undoing");
				//Log.i("ann","Board now:");
				//logBoard(null);
				//Log.i("ann","Going back to:");
				//logBoard(undolist.get(undolist.size()-1));
				System.arraycopy(undolist.get(undolist.size()-1),0,this.board,0,this.board.length);
				//logBoard(null);
				undolist.remove(undolist.size()-1);
				moves--;
				setTitle(currentLevel.title+" "+Integer.toString(moves)+"/"+Integer.toString((currentLevel.solution.length()/2)));
				//      TextView tv = (TextView) ((Activity) mContext).findViewById(R.id.score);
				//      tv.setText(Integer.toString(moves)+"/"+Integer.toString((solution.length()/2)));
				countEm();
			} else {
				Log.i("DEXEV","Nothing to undo");
			}
		}

		public void onItemClick(AdapterView<?> parent, View v, int position, long id) {
			Log.i("DEXEV","Item number "+position+" selected");
			if (XY==null) {
				XY=pos2coord(position);
			}
		}

		public boolean onKey(View v, int KeyCode, KeyEvent event) {
			if (this.XY!=null) {
				Log.i("DEXEV","onKey("+v+","+KeyCode+","+event+")");
				int[] newXY=new int[2];
				newXY[1]=this.XY[1];
				if (KeyCode==21) {
					newXY[0]=this.XY[0]-1;
				} else {
					newXY[0]=this.XY[0]+1;
				}
				moveFromTo(this.XY,newXY);
				this.XY=null;
				return true;
			}
			return false;
		}

		public boolean moveFromTo(final int[] oldXY, final int[] newXY) {
			
			int dir=0;
			if ((newXY[1]==oldXY[1]) || (Math.abs(newXY[1]-oldXY[1])==1)) {
				if (newXY[0]>oldXY[0]) {
					dir=1;
				} else if (newXY[0]<oldXY[0]) {
					dir=-1;
				}
			}
			if (dir!=0) {
				//  Log.i("ann","Saved for undo:");
				//logBoard(undolist.get(undolist.size()-1));

				@SuppressWarnings("unused")
				boolean moved=moveBlock(oldXY,dir);
//				while (moved) {
//					while (moved) {
//						countEm();
//						moved=doGravity();
//					}
//					countEm();
//					moved=doExplosion();
//				}

				return true;
			}
			return false;
		}
		public boolean onTouch(View v, MotionEvent event) {
			if (event.getAction()==MotionEvent.ACTION_DOWN) {
				this.XY=getXY(event);
				//Log.i("ann","ACTION_DOWN, ("+this.XY[0]+","+this.XY[1]+")");
				return true;
			} else if (event.getAction()==MotionEvent.ACTION_UP) {
				int[] newXY=getXY(event);
				boolean didmove=moveFromTo(this.XY,newXY);
				this.XY=null;
				return didmove;

			}
			return false;

		}



		public int getCount() {
			return 10*(this.board.length);
		}

		public boolean isEmpty() {
			return getCount()==0;
		}

		public int[] pos2coord(int position) {
			int[] coord=new int[2];
			coord[0]=position%10;
			coord[1]=position/10;
			return coord;
		}

		public Object getItem(int position) {
			int[] coord=pos2coord(position);
			return this.ivs[coord[1]][coord[0]];
		}

		public long getItemId(int position) {
			int[] coord=pos2coord(position);
			return this.ivs[coord[1]][coord[0]].getId();
		}

		public int getSkin() {
			return this.skin;
		}

		public void setSolution(String solution) {
			this.solution = solution;
		}

		public String getSolution() {
			return solution;
		}

	}
}
