package net.ekiii.dexev2;

import java.util.ArrayList;

import org.xmlpull.v1.XmlPullParser;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PixelFormat;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Path.Direction;
import android.graphics.Region.Op;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.AdapterView.OnItemSelectedListener;

public class Main extends Activity implements OnClickListener,OnItemSelectedListener
{
	
	private final static boolean DEMO =false;
	ArrayList<LevelSet> levelsets;
	private DatabaseHelper dbhelper;
	private SQLiteDatabase db;

	 public static final String PREFS_NAME = "MyPrefsFile";
	 public static final String SOUND = "SOUND";
	 public static final String ANIMATION = "ANIMATION";

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		this.levelsets=loadLevels();

		Spinner sp=(Spinner) findViewById(R.id.lsspinner);
		dbhelper=new DatabaseHelper((Context) this);
		db=dbhelper.getWritableDatabase();
		LevelSetListAdapter lsa=new LevelSetListAdapter(this, this.levelsets, db);
		sp.setOnItemSelectedListener(this);
		sp.setAdapter(lsa);
		Button pb=(Button) findViewById(R.id.playbutton);

		StateListDrawable sld4 = new StateListDrawable();
		sld4.addState(new int[]{android.R.attr.state_focused}, getResources().getDrawable(R.drawable.boutonwhite));
		sld4.addState(new int[]{android.R.attr.state_pressed}, getResources().getDrawable(R.drawable.boutonpp));
		sld4.addState(new int[]{android.R.attr.state_enabled}, getResources().getDrawable(R.drawable.boutonblack));
		pb.setTextColor(Color.rgb(200, 200, 200));
		pb.setTextColor(Color.rgb(200, 200, 200));
		pb.setTextSize(pb.getTextSize()*2.f);
		pb.setBackgroundDrawable(sld4);
		pb.setOnClickListener(this);

	}

	class LevelSet {
		ArrayList<Level> levels;
		String name;
		String author;
		String description;

		public LevelSet(ArrayList<Level> l, String n, String a, String d) {
			this.levels=l;
			this.name=n;
			this.author=a;
			this.description=d;
		}
	}

	private static class DatabaseHelper extends SQLiteOpenHelper {

		DatabaseHelper(Context context) {
			super(context, "dexev", null, 1);
		}

		@Override
		public void onCreate(SQLiteDatabase db) {

			db.execSQL("CREATE TABLE levelsets (_id integer primary key autoincrement, name text not null, completed integer null)");
			db.execSQL("CREATE TABLE levels (_id integer primary key autoincrement, levelset integer not null, level integer not null, score integer not null)");
		}

		@Override
		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
			//Log.i("ann","Would be updating database here if I cared enough");
			//onCreate(db);
		}
	}

	public boolean onCreateOptionsMenu(Menu menu) {
		MenuItem clear=menu.add(0,3,0,"Preferences");
		clear.setIcon(android.R.drawable.ic_menu_preferences);
		MenuItem help=menu.add(0,1,0,"Help");
		help.setIcon(android.R.drawable.ic_menu_help);
		MenuItem exit = menu.add(0,0,0,"Exit");
		exit.setIcon(android.R.drawable.ic_menu_close_clear_cancel);
//		MenuItem hint=menu.add(0,2,0,"Hint");
//		hint.setIcon(android.R.drawable.ic_menu_search);
		return true;
	}

	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case 0:
			finish();
			System.exit(0);
		case 1:
			new AlertDialog.Builder(this)
			.setTitle("Help")
			.setMessage(this.getResources().getText(R.string.help))
			.show();
			break;
		case 2:
			
			new AlertDialog.Builder(this)
			.setTitle("Hint")
			.setMessage(this.getResources().getText(R.string.help))
			.show();
			break;
		case 3:
			Intent settingsActivity = new Intent(getBaseContext(), Preferences.class);
			startActivity(settingsActivity);
			break;
		}
		return false;
	}
	
	
	@Override
	protected void onActivityResult(int rq, int rc, Intent i) {
		Button pb;
		Spinner sp;
		Cursor c;
		if (rc!=RESULT_CANCELED) {
			int score=i.getIntExtra("net.ekiii.dexev.Score",0);
			sp=(Spinner) findViewById(R.id.lspinner);
			int l=sp.getSelectedItemPosition();
			sp=(Spinner) findViewById(R.id.lsspinner);
			LevelSet ls=(LevelSet) sp.getSelectedItem();
			c=db.query("levelsets", new String[] {"_id"},"name=?",new String[] {ls.name},null,null,null);
			ContentValues args=new ContentValues();
			args.put("name",ls.name);
			args.put("completed",l);
			if (c.getCount()==1) {
				c.moveToFirst();
				db.update("levelsets",args, "_id=?",new String[] {Integer.toString(c.getInt(0))});
			} else {
				db.insert("levelsets",null, args);
			}
			c.close();
			c=db.query("levelsets", new String[] {"_id"},"name=?",new String[] {ls.name},null,null,null);
			c.moveToFirst();
			int lsid=c.getInt(0);
			c.close();
			c=db.query("levels", new String[] {"_id","score"},"levelset="+lsid+" and level="+l,null,null,null,null);
			args=new ContentValues();
			args.put("score",score);
			args.put("levelset",lsid);
			args.put("level",l);
			if (c.getCount()==1) {
				c.moveToFirst();
				int oldscore=c.getInt(1);
				if (score<oldscore) {
					db.update("levels",args, "_id=?",new String[] {Integer.toString(c.getInt(0))});
				}
			} else {
				db.insert("levels",null, args);
			}
			c.close();
			sp=(Spinner) findViewById(R.id.lspinner);
			sp.postInvalidate();
			switch (rc) {
			case 1: 
				sp=(Spinner) findViewById(R.id.lspinner);
				sp.setSelection(sp.getSelectedItemPosition()+1);
				pb=(Button) findViewById(R.id.playbutton);
				pb.performClick();
				break;
			case 2:
				pb=(Button) findViewById(R.id.playbutton);
				pb.performClick();
				break;
			case 3:
				break;
			}
		}
	}

	public void onClick(View v) {
		if (v.getId()==R.id.playbutton) {
			Intent i=new Intent(this, Game.class);
			Spinner sp=(Spinner) findViewById(R.id.lspinner);
			if (DEMO&&sp.getSelectedItemPosition()>1)
			{
				new AlertDialog.Builder(this)
				.setTitle("Demo")
				.setMessage(this.getResources().getText(R.string.demo))
				.show();
			}
			else
			{
			Level l=(Level) sp.getSelectedItem();
			if (l==null)
				return;
			i=i.putExtra("net.ekiii.dexev.Board",l.origboard);
			i=i.putExtra("net.ekiii.dexev.Title",l.title);
			i=i.putExtra("net.ekiii.dexev.Solution",l.solution);
			startActivityForResult(i,0);
			}
		}
	}

	public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
		Spinner lssp=(Spinner) findViewById(R.id.lsspinner);
		LevelSet ls=(LevelSet) lssp.getSelectedItem();
		Spinner sp=(Spinner) findViewById(R.id.lspinner);
		LevelListAdapter la=new LevelListAdapter(this, ls);
		//Cursor c=db.query("levelsets", new String[] {"_id"},"name=?",new String[] {ls.name},null,null,null);
		sp.setAdapter(la);
	}

	public void onNothingSelected(AdapterView<?> parent) {
	}

	class LevelListAdapter extends BaseAdapter {

		LevelSet levelset;
		Context mContext;

		public LevelListAdapter(Context c, LevelSet ls) {
			mContext=(Context) c;
			levelset=ls;
		}

		public int getCount() {
			return levelset.levels.size();
		}

		public boolean isEmpty() {
			return getCount()==0;
		}

		public Object getItem(int position) {
			Log.i("ann","Getting item position "+position);
			return levelset.levels.get(position);
		}

		public long getItemId(int position) {
			return 0;
		}


		private class BlueDrawable extends Drawable {
			protected Level m;

			Path p =new Path();
			int size =4;
			int size_2;
			private BlueDrawable(Level level) {
				this.m = level;
				p.addOval(new RectF(0, 0, getMinimumWidth()*2,getMinimumHeight()*2), Direction.CCW);
				size_2 = size/2;
			}

			private int getBitmap(char char$) {
				switch (char$) {
				case '0': //Wall
					return Color.argb(255, 0, 0, 0);
				case '1': 
					return Color.argb(255, 200, 255, 0);
				case '2': 
					return Color.argb(255, 255, 0, 0);
				case '3': 
					return Color.argb(255, 255, 200, 0);
				case '4': 
					return Color.argb(255, 0, 255, 0);
				case '5': 
					return Color.argb(255, 0, 0, 255);
				case '6': 
					return Color.argb(255, 255, 255, 0);
				case '7': 
					return Color.argb(255, 0, 255, 100);
				case '8': 
					return Color.argb(255, 0, 0, 0);
				case 'B': 
					return Color.argb(255, 255, 255, 255);

				default:
					break;
				}
				return Color.argb(255, 255, 255, 255);
			}

			@Override
			public void draw(Canvas canvas) {
				StringBuffer[] board = m.board;
				int i=0;
				int black = Color.argb(0, 0, 0, 0);
				int c1 = Color.argb(128, 255, 255, 255);
				int c2 = Color.argb(0, 255, 255, 255);
				LinearGradient gd;
				LinearGradient gd2;
				Paint paint = new Paint();
				int argb = Color.argb(128, 0, 0, 0);
				canvas.saveLayer(0, 0, getIntrinsicWidth(), getMinimumHeight(), null, Canvas.FULL_COLOR_LAYER_SAVE_FLAG);

				try {
					for (StringBuffer sb:board)
					{
						int isize = i*size;
						int sizeisize = isize+size_2;
						int isizesize = isize+size;
						for (int j=0;j<10;j++)
						{
							char char$ = sb.charAt(j);

//							canvas.save();
							int bitmap = getBitmap(char$);
							int jsize = j*size;
							gd= new LinearGradient(jsize, isize, jsize+size,isizesize, bitmap, Color.WHITE, Shader.TileMode.REPEAT);
							paint.setShader(gd);
//							canvas.clipRect(jsize, isize, jsize+size,isize+size);
							canvas.drawRect(jsize, isize, jsize+size,isizesize, paint);
							gd2= new LinearGradient(jsize, isize, jsize+size_2,sizeisize,argb, black
									,Shader.TileMode.REPEAT);
							paint.setShader(gd2);
							canvas.drawRect(jsize, isize, jsize+size,isizesize, paint);
							//						canvas.drawARGB(Color.alpha(bitmap), Color.red(bitmap), Color.green(bitmap), Color.blue(bitmap));
//							canvas.restore();

							//					canvas.drawPoint(j*2,i*2, null);
							//					canvas.drawPoint(j*2+1,i*2, null);
							//					canvas.drawPoint(j*2,i*2+1, null);
							//					canvas.drawPoint(j*2+1,i*2+1, null);
							//					if ((c!='0') && (c!='9')) {
							//				          tot++;
							//				          this.jewels[Character.getNumericValue(c)]++;
							//				        }

						}
						i++;

					}// Fin boucle

					canvas.save();
					canvas.clipPath(p, Op.DIFFERENCE);
					gd= new LinearGradient(0, 0, 0, getMinimumHeight(), c1,c2, Shader.TileMode.REPEAT);
					paint.setShader(gd);
					canvas.drawRect(0, 0, getMinimumWidth(),getMinimumHeight(), paint);
					canvas.restore();
					canvas.restore();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

			@Override
			public int getOpacity() {
				return PixelFormat.TRANSLUCENT;
			}

			@Override
			public void setAlpha(int alpha) {

			}

			@Override
			public void setColorFilter(ColorFilter cf) {

			}

			@Override
			public int getIntrinsicHeight() {
				return size<<3;
			}

			@Override
			public int getIntrinsicWidth() {
				return size*10;
			}

			@Override
			public int getMinimumHeight() {
				return size<<3;
			}

			@Override
			public int getMinimumWidth() {
				return size*10;
			}

			public void setLevel(Level level) {
				m=level;
			}


		}

		//WeakHashMap<Level, BlueDrawable> cache = new WeakHashMap<Level, BlueDrawable>();
		
		public View getView(int position, View convertView, ViewGroup parent) {
			LinearLayout linearLayout;
			TextView tv;
			ImageView im;
			if (convertView == null) {  // if it's not recycled, initialize some attributes
				linearLayout = new LinearLayout(Main.this);
				im = new ImageView(Main.this);
				tv = new TextView(mContext);
				BlueDrawable blueDrawable =/* cache.get(levelset.levels.get(position));
				if (blueDrawable==null)
				{
					blueDrawable=*/ new BlueDrawable(levelset.levels.get(position));
					/*cache.put(levelset.levels.get(position), blueDrawable);
				}*/
				im.setImageDrawable(blueDrawable);
				im.setPadding(0, 1, 5, 1);
				linearLayout.addView(im);
				linearLayout.addView(tv);
			} else {
				linearLayout = (LinearLayout) convertView;
				im = (ImageView) linearLayout.getChildAt(0);
				tv = (TextView) linearLayout.getChildAt(1);
				((BlueDrawable)im.getDrawable()).setLevel(levelset.levels.get(position));
			}
			
			String lname;
			Cursor c;
			c=db.query("levelsets", new String[] {"_id"},"name=?",new String[] {levelset.name},null,null,null);
			int lsid=-1;
			if (c.getCount()==1) {
				c.moveToFirst();
				lsid=c.getInt(0);
			}
			c.close();
			int score=-1;
			lname=levelset.levels.get(position).title;
			if (lsid!=-1) {
				c=db.query("levels", new String[] {"score"},"levelset="+lsid+" and level="+position,null,null,null,null);
				if (c.getCount()==1) {
					c.moveToFirst();
					score=c.getInt(0);
				}
				c.close();
			}
			lname+="\n     Par "+(levelset.levels.get(position).solution.length()/2+" - ");
			if (score!=-1) {
				lname+="completed in "+score;
			} else {
				lname+="never completed!";
			}
			tv.setText(lname);
			if (parent instanceof Spinner||(position>1&&DEMO))
				tv.setTextColor(Color.argb(255, 200, 200, 200));
			else
				tv.setTextColor(Color.argb(255, 0, 0, 0));
				
			//        Drawable drawable = getResources().getDrawable(R.drawable.b2);
			//        tv.setB
			

			return linearLayout; 
		}
	}
	class LevelSetListAdapter extends BaseAdapter {

		ArrayList<LevelSet> levelsets;
		Context mContext;

		public LevelSetListAdapter(Context c, ArrayList<LevelSet> ls, SQLiteDatabase db) {
			mContext=(Context) c;
			levelsets=ls;
		}

		public int getCount() {
			return levelsets.size();
		}

		public boolean isEmpty() {
			return getCount()==0;
		}

		public Object getItem(int position) {
			return levelsets.get(position);
		}

		public long getItemId(int position) {
			return 0;
		}

		public View getView(int position, View convertView, ViewGroup parent) {
			TextView tv;
			String lsname;
			if (convertView == null) {  // if it's not recycled, initialize some attributes
				tv = new TextView(mContext);
			} else {
				tv = (TextView) convertView;
			}
			lsname=levelsets.get(position).name+" By "+levelsets.get(position).author;
			Cursor c=db.query("levelsets", new String[] {"_id"},"name=?",new String[] {lsname},null,null,null);
			int completed=0;
			if (c.getCount()==1) {
				c.moveToFirst();
				String id=c.getString(0);
				c.close();
				c=db.query("levels",new String[] {"score"},"levelset=?",new String[] {id},null,null,null);
				completed=c.getCount();
			}
			c.close();
			if (!(parent instanceof Spinner))
				lsname+="\n       "+levelsets.get(position).description;
			lsname+="\n     "+completed+" levels completed of "+levelsets.get(position).levels.size()+" total";
			tv.setText(lsname);
			if (parent instanceof Spinner)
				tv.setTextColor(Color.argb(255, 200, 200, 200));
			else
				tv.setTextColor(Color.argb(255, 0, 0, 0));
				
			return tv;
		}
	}

	public ArrayList<LevelSet> loadLevels() {

		String title="";
		String description="";
		String name="";
		String board="";
		String author="";
		String solution="";
		ArrayList<LevelSet> levelsets=new ArrayList<LevelSet>();
		ArrayList<Level> levels=null;
		XmlResourceParser x=getResources().getXml(R.xml.levels);
		try {
			int state=x.getEventType();
			while (state!=XmlPullParser.END_DOCUMENT) {
				if (state==XmlPullParser.START_TAG) {
					if (x.getName().equals("board")) {
						state=x.next();
						board=x.getText().trim();
					} else if (x.getName().equals("solution")) {
						state=x.next();
						solution=x.getText().trim();
					} else if (x.getName().equals("level")) {
						title=x.getAttributeValue(null,"title");
					} else if (x.getName().equals("levelpack")) {
						levels=new ArrayList<Level>();
						author=x.getAttributeValue(null,"author");
						description=x.getAttributeValue(null,"description");
						name=x.getAttributeValue(null,"name");
					}
				} else if (state==XmlPullParser.END_TAG) {
					if (x.getName().equals("level")) {
						Level l=new Level(title, board, solution);
						levels.add(l);
					} else if (x.getName().equals("levelpack")) {
						LevelSet ls=new LevelSet(levels, name, author, description);
						levelsets.add(ls);
					}
				}
				state=x.next();
			}
		} catch (org.xmlpull.v1.XmlPullParserException e) {
			e.printStackTrace();
		} catch (java.io.IOException e) {
			e.printStackTrace();
		}
		return levelsets;
	}
}
