package net.ekiii.dexev2;


import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.PreferenceActivity;

public class Preferences extends PreferenceActivity implements OnSharedPreferenceChangeListener {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		addPreferencesFromResource(R.xml.preference);
	}
	
	
    protected void onResume() {
        super.onResume();

        // Setup the initial values
//        mCheckBoxPreference.setSummary(sharedPreferences.getBoolean(key, false) ? "Disable this setting" : "Enable this setting");
//        mListPreference.setSummary("Current value is " + sharedPreferences.getValue(key, "")); 

        // Set up a listener whenever a key changes            
        getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
    }

    protected void onPause() {
        super.onPause();

        // Unregister the listener whenever a key changes            
        getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);    
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        // Let's do something a preference value changes
//        if (key.equals(KEY_CHECKBOX_PREFERENCE)) {
//          mCheckBoxPreference.setSummary(sharedPreferences.getBoolean(key, false) ? "Disable this setting" : "Enable this setting");
//        }
//        else if (key.equals(KEY_LIST_PREFERENCE)) {
//          mListPreference.setSummary("Current value is " + sharedPreferences.getValue(key, "")); 
//        }
    	SharedPreferences preferences = getSharedPreferences(Main.PREFS_NAME, 0);
    	if (key.equals(Main.SOUND)) {
        	Editor edit = preferences.edit();
			boolean isRandom = sharedPreferences.getBoolean(Main.SOUND, true);
			edit.putBoolean(Main.SOUND, isRandom);
			edit.commit();
//			random.setTitle("Order: "+(isRandom?"Random":"Natural"));
        }
    	else if (key.equals(Main.ANIMATION)) {
    		Editor edit = preferences.edit();
    		boolean isRandom = sharedPreferences.getBoolean(Main.ANIMATION, true);
    		edit.putBoolean(Main.ANIMATION, isRandom);
    		edit.commit();
//			random.setTitle("Order: "+(isRandom?"Random":"Natural"));
    	}
    }

}
